---
generated_at: 2026-01-27 12:58:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-npm run test-treeshake.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scripts.test-treeshake定義
- E-02: `test/rollup.treeshake.config.js` - Rollup設定ファイル
- E-03: `test/treeshake/index.js` - WebGL版エントリポイント
- E-04: `test/treeshake/index.webgpu.js` - WebGPU版エントリポイント
- E-05: `test/treeshake/index.webgpu.nodes.js` - WebGPU Nodes版エントリポイント
- E-06: `.github/workflows/read-size.yml` - CIワークフロー
- E-07: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コマンドは`rollup -c test/rollup.treeshake.config.js`を実行 | E-01 | ○ |
| C-02 | 6つのRollup設定を含む | E-02 (lines 52-131) | ○ |
| C-03 | WebGL版エントリポイントはtest/treeshake/index.js | E-02 (line 54) | ○ |
| C-04 | WebGPU版エントリポイントはtest/treeshake/index.webgpu.js | E-02 (line 80) | ○ |
| C-05 | WebGPU Nodes版エントリポイントはtest/treeshake/index.webgpu.nodes.js | E-02 (line 106) | ○ |
| C-06 | 出力先はtest/treeshake/index.bundle.js等 | E-02 (lines 61, 75, 87, 101, 113, 127) | ○ |
| C-07 | terserプラグインでminification | E-02 (lines 69, 95, 121) | ○ |
| C-08 | カスタムfilesizeプラグインでサイズ出力 | E-02 (lines 5-50, 70, 96, 122) | ○ |
| C-09 | resolveプラグインを使用 | E-02 (lines 56, 68, 82, 94, 108, 120) | ○ |
| C-10 | ESM形式で出力 | E-02 (lines 60, 74, 86, 100, 112, 126) | ○ |
| C-11 | WebGL版はTHREE.WebGLRendererを使用 | E-03 (line 13) | ○ |
| C-12 | WebGPU版はTHREE.WebGPURendererを使用 | E-04 (line 13) | ○ |
| C-13 | WebGPU Nodes版はThree.WebGPU.Nodes.jsをインポート | E-05 (line 1) | ○ |
| C-14 | 最小構成でPerspectiveCamera、Scene、Rendererを使用 | E-03, E-04, E-05 | ○ |
| C-15 | gzip圧縮後サイズも計算して出力 | E-02 (lines 1, 20) | ○ |
| C-16 | read-size.ymlでバンドルサイズを取得 | E-06 (lines 37-57) | ○ |
| C-17 | src/, package.json, utils/build/変更時にトリガー | E-06 (lines 3-8) | ○ |
| C-18 | バンドルサイズはKB単位で出力 | E-02 (lines 19-20) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Rollup設定ファイルから完全に処理内容を把握可能
- 0: 低リスク - エントリポイントのコードも明確で最小構成

## 6) レビュアーチェックリスト（最小）
- [ ] バンドルサイズが前回リリースから大幅に増加していないか確認
- [ ] 新規追加されたコードがtree-shakingで適切に除去されるか確認
